﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Web_Files_Enhanced
{
    class RolloverToolStripButton : ToolStripButton
    {
        private Image _mouseEnterImage, _mouseLeaveImage;

        protected override void OnMouseEnter(EventArgs e)
        {
            base.OnMouseEnter(e);

            if (_mouseEnterImage != null)
            {
                this.Image = _mouseEnterImage;
            }
        }

        protected override void OnMouseLeave(EventArgs e)
        {
            base.OnMouseLeave(e);

            if (_mouseLeaveImage != null)
            {
                this.Image = _mouseLeaveImage;
            }
        }

        [DefaultValue(null)]
        [Category("Appearance")]
        public Image MouseEnterImage
        {
            get { return _mouseEnterImage; }
            set { _mouseEnterImage = value; }
        }

        [DefaultValue(null)]
        [Category("Appearance")]
        public Image MouseLeaveImage
        {
            get { return _mouseLeaveImage; }
            set 
            { 
                _mouseLeaveImage = value;
                // Autoset initial image
                this.Image = _mouseLeaveImage;
            }
        }
    }
}
